clear all;
close all;
clc;

%Caricamento delle matrici O/D e della mappatura
load 'IMQ2013_zonecampionarie';
fprintf('File MAT di riferimento:  IMQ2013_zonecampionarie.mat\n\n');

%Ottenimento dei dati di ingresso
zona = input('Inserire codice zona:     ');
modo = input('Inserire il modo (Pr-privato, Pu-pubblico, T-totali): ');
per = input('Periodo (IG-intera giornata, OP-ora di punta): ');
if per == 'IG';
    scopo = input('Scopo (t-tutti, sr-tutti escluso ritorno): ');
else;
    scopo = 't';
end;

%Determinazione dei flussi totali in uscita e in entrata
if modo=='T';
    nomeMATR1 = strcat('ResPIEmPu',per,scopo);
    nomeMATR2 = strcat('ResPIEmPr',per,scopo);
    if per=='IG',scopo=='sr';
        [FProd,FAttr] = flussototale(ResPIEmPrIGsr,zoneA,zona)+flussototale(ResPIEmPuIGsr,zoneA,zona);
        stampafileT(ResPIEmPrIGsr,ResPIEmPuIGsr,zona,zoneA,coordX,coordY);
    end; if per=='IG',scopo=='t';
        [FProd,FAttr] = flussototale(ResPIEmPrIGt,zoneA,zona)+flussototale(ResPIEmPuIGt,zoneA,zona);
        stampafileT(ResPIEmPrIGt,ResPIEmPuIGt,zona,zoneA,coordX,coordY);
    end; if per=='OP',scopo=='t';
        [FProd,FAttr] = flussototale(ResPIEmPrOPt,zoneA,zona)+flussototale(ResPIEmPuOPt,zoneA,zona);
        stampafileT(ResPIEmPrOPt,ResPIEmPuOPt,zona,zoneA,coordX,coordY);
    end;
    fprintf('\nMatrici di riferimento:  ');fprintf(nomeMATR1);fprintf(' / ');fprintf(nomeMATR2);
else;
    nomeMATR = strcat('ResPIEm',modo,per,scopo);
    if modo=='Pu',per=='IG',scopo=='sr';
        [FProd,FAttr] = flussototale(ResPIEmPuIGsr,zoneA,zona);
        stampafile(ResPIEmPuIGsr,zona,zoneA,coordX,coordY);
    end; if modo=='Pu',per=='IG',scopo=='t';
        [FProd,FAttr] = flussototale(ResPIEmPuIGt,zoneA,zona);
        stampafile(ResPIEmPuIGt,zona,zoneA,coordX,coordY);
    end; if modo=='Pu',per=='OP',scopo=='t';
        [FProd,FAttr] = flussototale(ResPIEmPuOPt,zoneA,zona);
        stampafile(ResPIEmPuOPt,zona,zoneA,coordX,coordY);
    end; if modo=='Pr',per=='IG',scopo=='sr';
        [FProd,FAttr] = flussototale(ResPIEmPrIGsr,zoneA,zona);
        stampafile(ResPIEmPrIGsr,zona,zoneA,coordX,coordY);
    end; if modo=='Pr',per=='IG',scopo=='t';
        [FProd,FAttr] = flussototale(ResPIEmPrIGt,zoneA,zona);
        stampafile(ResPIEmPrIGt,zona,zoneA,coordX,coordY);
    end; if modo=='Pr',per=='OP',scopo=='t';
        [FProd,FAttr] = flussototale(ResPIEmPrOPt,zoneA,zona);
        stampafile(ResPIEmPrOPt,zona,zoneA,coordX,coordY);
    end;
    fprintf('\nMatrice di riferimento:  ');fprintf(nomeMATR);
end;

%Stampa a video dei risultati
fprintf('\nSPOSTAMENTI TOTALI IN USCITA:    ');fprintf('%.12f',FProd);
fprintf('\nSPOSTAMENTI TOTALI IN ENTRATA:   ');fprintf('%.12f',FAttr);
fprintf('\n\nGenerati i file:  SpostProd.txt / SpostAttr.txt\n');

%Definizione della funzione di somma degli spostamenti
function [FP,FA] = flussototale(matrice,zone,Z);
FP = sum(matrice(find(zone==Z),:));
FA = sum(matrice(:,find(zone==Z)));
end

%Definizione della funzione di stampa su file
function stampafile(matrice,Z,zone,CX,CY);
filePROD = fopen('SpostProd.txt','w');
fileATTR = fopen('SpostAttr.txt','w');
zone(209)=[]; matrice(209,:)=[];matrice(:,209)=[];
SP = matrice(find(zone==Z),:);
stampaP = [zone SP' CX CY]; stampaP(find(zone==Z),:)=[]; stampaP=stampaP';
fprintf(filePROD,'%s %f %f %f\r\n',stampaP);
SA = matrice(:,find(zone==Z));
stampaA = [zone SA CX CY]; stampaA(find(zone==Z))=[]; stampaA=stampaA';
fprintf(fileATTR,'%s %f %f %f\r\n',stampaA);
fclose('all');
end

function stampafileT(matricePR,matricePU,Z,zone,CX,CY);
filePROD = fopen('SpostProd.txt','w');
fileATTR = fopen('SpostAttr.txt','w');
zone(209)=[]; 
matricePR(209,:)=[];matricePR(:,209)=[];
matricePU(209,:)=[];matricePU(:,209)=[];
SP = matricePU(find(zone==Z),:)+matricePR(find(zone==Z),:);
stampaP = [zone SP' CX CY]; stampaP(find(zone==Z),:)=[]; stampaP=stampaP';
fprintf(filePROD,'%s %f %f %f\r\n',stampaP);
SA = matricePU(:,find(zone==Z))+matricePR(:,find(zone==Z));
stampaA = [zone SA CX CY]; stampaA(find(zone==Z))=[]; stampaA=stampaA';
fprintf(fileATTR,'%s %f %f %f\r\n',stampaA);
fclose('all');
end








